import argparse

def parse_args(input_args=None):
    parser = argparse.ArgumentParser(description="Simple example of a training script.")
    parser.add_argument(
        "--sd_pretrained_model_name_or_path",
        type=str,
        default='runwayml/stable-diffusion-v1-5',
        required=False,
        help="Path to pretrained stable diffusion model or model identifier from huggingface.co/models.",
    )
    parser.add_argument(
        "--dreambooth",
        action="store_true",
        help="Use dreambooth as baseline",
    )
    parser.add_argument(
        "--pm_pretrained_model_name_or_path",
        type=str,
        default='',
        required=False,
        help="Path to pretrained personalized model or model identifier from huggingface.co/models.",
    )
    parser.add_argument(
        "--textual_inversion",
        action="store_true",
        help="Use textual inversion as baseline",
    )
    parser.add_argument(
        "--blip_diffusion",
        action="store_true",
        help="Use blip diffusion as baseline",
    )
    parser.add_argument(
        "--subject_name",
        type=str,
        default=None,
        required=True,
        help="subject name of dreambooth dataset",
    )
    parser.add_argument(
        "--ref_dir",
        type=str,
        default=None,
        required=True,
        help="reference image directory",
    )
    parser.add_argument(
        "--class_token",
        type=str,
        default=None,
        required=True,
        help="class token of dreambooth dataset",
    )
    parser.add_argument(
        "--unique_token",
        type=str,
        default=None,
        required=True,
        help="unique token of dreambooth dataset",
    )
    parser.add_argument(
        "--num_images",
        type=int,
        default=4,
        required=False,
        help="num of images to generate",
    )

    args = parser.parse_args()
    return args